/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.ReplaceOperation;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.utils.BlockCondition;
import imgui.ImGui;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6885;

public class QuickReplaceWindow {
    private static class_2680 from;
    private static class_6885<class_2248> fromTag;
    private static final SelectBlockWidget fromBlockWidget;
    private static final SelectBlockWidget toBlockWidget;
    public static boolean openQuickReplaceWindow;

    public static void render(BlockList blockList) {
        class_6885<class_2248> holderSet;
        boolean openFrom;
        if (Placement.INSTANCE.isPlacing()) {
            return;
        }
        boolean bl = openFrom = !ImGui.getIO().getWantTextInput() && Keybinds.QUICK_REPLACE.isPressed(false) && !Selection.getSelectionBuffer().isEmpty();
        if (openFrom || openQuickReplaceWindow) {
            if (ToolManager.isToolActive()) {
                ToolManager.getCurrentTool().reset();
            }
            if (Selection.getSelectionBuffer().isEmpty()) {
                return;
            }
            fromBlockWidget.open();
            openQuickReplaceWindow = false;
        } else if (Selection.getSelectionBuffer().isEmpty()) {
            return;
        }
        fromBlockWidget.render(AxiomI18n.get("axiom.keybinds.quick_replace.replace_from"), blockList);
        CustomBlockState blockState = fromBlockWidget.getResultState();
        if (blockState != null) {
            from = blockState.getVanillaState();
            fromTag = null;
            toBlockWidget.open();
        }
        if ((holderSet = fromBlockWidget.getResultTag()) != null) {
            from = null;
            fromTag = holderSet;
            toBlockWidget.open();
        }
        toBlockWidget.render(AxiomI18n.get("axiom.keybinds.quick_replace.replace_to"), blockList);
        blockState = toBlockWidget.getResultState();
        if (blockState != null) {
            if (from != null) {
                ReplaceOperation.replace(new BlockCondition.AnyState(from.method_26204()), blockState.getVanillaState());
            } else if (fromTag != null) {
                ReplaceOperation.replace(new BlockCondition.MatchesTag(fromTag), blockState.getVanillaState());
            }
            from = null;
            fromTag = null;
        }
    }

    static {
        fromBlockWidget = new SelectBlockWidget(true);
        toBlockWidget = new SelectBlockWidget(false);
        openQuickReplaceWindow = false;
    }
}

